-- Autocracy_Opener.lua
-- Author: Machiavelli
-- DateCreated: 5/31/2012 1:51:00 PM
--------------------------------------------------------------
function GiveCultureWhenCreated(playerID, unitID, hexVec, unitType, cultureType, civID, primaryColor, secondaryColor, unitFlagIndex, fogState, selected, military, notInvisible)
	local player = Players[playerID];
	local unit = player:GetUnitByID(unitID);
	local unitDomain = unit:GetDomainType();
	local policyID = GameInfoTypes["POLICY_AUTOCRACY"];

	-- Only give the Culture if the player has the policy
	if(player:HasPolicy(policyID) and not player:IsPolicyBlocked(policyID) and unit:IsCombatUnit() and (unitDomain == DomainTypes["DOMAIN_LAND"] or unitDomain == DomainTypes["DOMAIN_HOVER"])) then
		local currentCulture = player:GetJONSCulture();
		local bonusCulture = unit:GetBaseCombatStrength();

		-- Give the culture
		player:SetJONSCulture(currentCulture + bonusCulture);

		-- Send a notification to the player
		local text = Locale.ConvertTextKey("TXT_KEY_CULTURE_FROM_AUTOCRACY", tostring(bonusCulture), unit:GetName());
		player:AddNotification(NotificationTypes.NOTIFICATION_GENERIC, text, text);
	end
end
LuaEvents.SerialEventUnitCreatedGood.Add(GiveCultureWhenCreated);